require( "HiddenObject/script/style.lua" );

HeadingColor	=	Color(131, 167, 184, 255);
SubHeadingColor	=	Color(131, 167, 184, 255);
TextColor		=	Color(204, 198, 183, 255);

TitleFont = {
  standardFont,
  50,
  HeadingColor
};


CloseButtonFont = {
  standardFont,
  28,
  SubHeadingColor
};


CloseGraphics = {
	"HiddenObject/UI/Button/closenormal",
	"HiddenObject/UI/Button/closedown",
	"HiddenObject/UI/Button/closeover"
};


CloseStyle = {
	parent = DefaultStyle,
	font = CloseButtonFont,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = CloseGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};

MakeDialog
{
	-- Name the modal dialog
	name="creditswindow",
	Bitmap
	{
		image="HiddenObject/UI/Background/creditsbackground",

		Bitmap
		{
			image="HiddenObject/UI/Credit/creditslogo",
			x = kCenter+20,
			y = 35,
		},

		Text
		{
			font = TitleFont,
			name = "title",
			x=kCenter,y=5,w=kMax ,h=75,
			flags = kHAlignCenter + kVAlignTop,
			label = "credits"
		};

		CreditsWindow
		{
			x = 0, y = 180,
			w = 800, h = 340,
			font = standardFont,
			fontsize = 24,
			fontcolor = TextColor;
			headercolor = SubHeadingColor;
			headerSize = 24,
			columngap = 50,
			columnwidth = 325,
			time = 60000, 		-- Time to play credits in milliseconds
			intropause = 3000, 	-- Time to pause credits at start, in ms
			file = "HiddenObject/UI/Credit/credits.txt",
			adjustment = 1.0,
		},


		SetStyle(CloseStyle),
		Button
		{
			x=kCenter,
			y=-53,
			font = CloseButtonFont,
			name="close",
			type = kPush,
			flags = kHAlignCenter + kVAlignCenter,
			label="close",
			command =
				function()
					PopModal("creditswindow");
				end
		};
	},
}